<!-- PayPal SDK -->
    <script src="https://www.paypal.com/sdk/js?client-id=YOUR_SANDBOX_CLIENT_ID&currency=USD"></script>
    
    <script>
        // Wait for the DOM to be fully loaded
        document.addEventListener('DOMContentLoaded', function() {
            // Get DOM elements
            const payButton = document.getElementById('payButton');
            const heroSection = document.getElementById('heroSection');
            const confirmationSection = document.getElementById('confirmationSection');
            const backToHome = document.getElementById('backToHome');
            
            // Set today's date in the confirmation section
            const today = new Date();
            const formattedDate = today.toLocaleDateString('en-US', { 
                year: 'numeric', 
                month: 'long', 
                day: 'numeric' 
            });
            document.getElementById('transactionDate').textContent = formattedDate;
            
            // Generate a random transaction ID for demonstration
            const generateTransactionId = () => {
                return 'PAY-' + Math.random().toString(36).substring(2, 15).toUpperCase() + 
                       Math.random().toString(36).substring(2, 15).toUpperCase();
            };
            
            // Render PayPal button
            paypal.Buttons({
                // Configure the payment amount
                createOrder: function(data, actions) {
                    return actions.order.create({
                        purchase_units: [{
                            amount: {
                                value: '29.99'
                            },
                            description: 'Premium Service Subscription'
                        }]
                    });
                },
                
                // Handle successful payment
                onApprove: function(data, actions) {
                    return actions.order.capture().then(function(details) {
                        // Update transaction ID with real one from PayPal
                        document.getElementById('transactionId').textContent = details.id;
                        
                        // Hide hero section and show confirmation
                        heroSection.style.display = 'none';
                        confirmationSection.style.display = 'block';
                        
                        // Scroll to confirmation section
                        confirmationSection.scrollIntoView({ behavior: 'smooth' });
                    });
                },
                
                // Handle payment errors
                onError: function(err) {
                    console.error('PayPal payment error:', err);
                    alert('There was an error processing your payment. Please try again.');
                }
            }).render('#payButton'); // Render the PayPal button inside our custom button
            
            // Back to home functionality
            backToHome.addEventListener('click', function(e) {
                e.preventDefault();
                heroSection.style.display = 'block';
                confirmationSection.style.display = 'none';
                window.scrollTo({ top: 0, behavior: 'smooth' });
            });
        });
    </script>